let metadb = require('common/metadb');

const settingsPath = 'MAIN_MODULE_MANAGEMENT/customers/cdev.console/Config/aguilaLogChannel';

let aon = {
  type: 'agorum.vbox',
  title: '',
  width: 300,
  // height: 300,
  items: [
    {
      type: 'agorum.hbox',
      flexible: true,
      items: [
        {
          type: 'agorum.comboBox',
          name: 'separator',
          label: 'Entry separator',
          // width: 300,
          flexible: true,
        },
        {
          type: 'agorum.numberInput',
          name: 'repeat',
          increment: 10,
          integer: true,
          width: 60,
        },
      ],
    },
    {
      type: 'agorum.hbox',
      flexible: true,
      items: [
        {
          type: 'agorum.comboBox',
          name: 'mode',
          label: 'Entry mode',
          // width: 150,
          flexible: true,
          value: 0,
          restricted: true,
          readonly: true,
          data: [
            {
              text: 'insert',
              value: 0,
            },
            {
              text: 'append',
              value: 1,
            },
          ],
        },
      ],
    },
    {
      type: 'agorum.hbox',
      flexible: true,
      items: [
        {
          type: 'agorum.checkBox',
          name: 'stringify',
          label: 'Flags',
          text: 'Stringify objects',
          value: true,
        },
      ],
    },
  ],
};

function load() {
  let cs = Object.assign(
    {
      channel: 'aguila-log-channel',
      title: 'aguila log channel',
      mode: 0,
      stringify: true,
      separator: {
        data: [
          {
            text: '\u23AF',
            value: 0,
          },
        ],
        selected: 0,
        repeat: 128,
        value: null,
      },
    },
    JSON.parse(metadb.read(settingsPath))
  );

  if (!cs.separator.value) cs.separator.value = cs.separator.data[cs.separator.selected].text;

  return cs;
}

function init(sw, cs) {
  sw.items.separator.data = cs.separator.data;
  sw.items.separator.value = cs.separator.value;
  sw.items.repeat.value = cs.separator.repeat;
  sw.items.mode.value = cs.mode;
  sw.items.stringify.value = cs.stringify;
}

function update(sw, cs) {
  // console.log(sw.items.separator.value);
  if (isNaN(sw.items.separator.value)) {
    cs.separator.value = sw.items.separator.value;
  } else {
    cs.separator.selected = sw.items.separator.value;
    cs.separator.value = cs.separator.data[cs.separator.selected].text;
  }
  cs.separator.repeat = sw.items.repeat.value;
  cs.mode = sw.items.mode.value;
  cs.stringify = sw.items.stringify.value;

  metadb.write(settingsPath, JSON.stringify(cs));
  console.log(cs);
}

module.exports = {
  aon: aon,
  load: load,
  init: init,
  update: update,
};

if (module.id === 'main') {
  console.log('main');
  let cs = load();
  let sw = require('../widget-helper').create(aon, 'Settings');
  init(sw, cs);
  sw.widget.on('destroying', () => {
    update(sw, cs);
  });
  sw.widget;
}
